﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using DataAccess;

/// <summary>
/// Helper class used to conenct to database
/// </summary>
public class CAppDBConnection
{   
    /// <summary>
    /// empty constructor
    /// </summary>
    public CAppDBConnection()
	{
	}

     /// <summary>
    /// get a data connection
    /// </summary>
    public CDataConnection GetDataConnection()
    {
        //get the connection string from the web.config file
        //connection string is encrypted in the file using MS recommended procedures
        //
        //cd\
        //cd windows
        //cd microsoft.net
        //cd framework
        //cd v2.0.50727
        //aspnet_regiis -pe "connectionStrings" -app "/PrimeCarePlus" -prov "RsaProtectedConfigurationProvider"
        //
        //look for connection strings in connection strings and app settings
        string strConnectionString = "";
        try
        {
            //try to get the connection string from the encrypted connectionstrings section
            strConnectionString = ConfigurationManager.ConnectionStrings["DBConnString"].ConnectionString;
        }
        catch (Exception eee)
        {
            //pull from appsettings if failed, this lets developers connect from local boxes.
            //strConnectionString = System.Configuration.ConfigurationManager.AppSettings["DBConnString"];
            string strStatus = eee.Message;
        }

        bool bAudit = false;
        string strAudit = "";
        if (System.Configuration.ConfigurationManager.AppSettings["AUDIT"] != null)
        {   strAudit = System.Configuration.ConfigurationManager.AppSettings["AUDIT"].ToString();
            if (strAudit == "1")
            {
                bAudit = true;
            }
        }
        
        CDataConnection DBConnection;

        //create a new dataconnection object
        DBConnection = new CDataConnection();

        //Connect to the database, connection is housed in the master page 
        //so that all pages that use the master have access to it.
        if (!DBConnection.Connect(strConnectionString, (int)DataConnectionType.Oracle, bAudit))
        {
            return null;
        }

        return DBConnection;
    }
}
